<?php
// Pool Stats API
// Shows active connection pools and concurrent users
require_once 'config.php';
requireLogin();

header('Content-Type: application/json');

$stats = StreamPool::getPoolStats();
$cacheSize = getCacheSize();

echo json_encode([
    'success' => true,
    'pools' => [
        'active' => $stats['active_pools'],
        'total_users' => $stats['total_users']
    ],
    'cache' => [
        'size' => formatBytes($cacheSize),
        'size_bytes' => $cacheSize
    ],
    'streams' => getStreamStats()
]);
