<?php
// Updated config.php with includes
// Configuration File

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'diziproo_proxy');
define('DB_PASS', '-v-{)qkxFeL_');
define('DB_NAME', 'diziproo_proxyy');

// Site Configuration
define('SITE_URL', 'https://proxy.diz1.online');
define('BASE_PATH', __DIR__);

// Security
define('SESSION_LIFETIME', 3600); // 1 hour
define('TOKEN_LENGTH', 32);

// Streaming Configuration
define('BUFFER_SIZE', 8192);
define('SEGMENT_CACHE_DIR', BASE_PATH . '/cache/segments');
define('ENABLE_CACHE', true);
define('CACHE_LIFETIME', 300); // 5 minutes

// Create cache directory if it doesn't exist
if (!file_exists(SEGMENT_CACHE_DIR)) {
    mkdir(SEGMENT_CACHE_DIR, 0755, true);
}

// Database Connection
function getDBConnection() {
    static $conn = null;
    
    if ($conn === null) {
        try {
            $conn = new PDO(
                "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
                DB_USER,
                DB_PASS,
                [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false
                ]
            );
        } catch (PDOException $e) {
            die("Database connection failed: " . $e->getMessage());
        }
    }
    
    return $conn;
}

// Generate random token
function generateToken($length = TOKEN_LENGTH) {
    return bin2hex(random_bytes($length / 2));
}

// Load includes
require_once BASE_PATH . '/includes/functions.php';
require_once BASE_PATH . '/includes/auth.php';
require_once BASE_PATH . '/includes/stream_pool.php';
