-- ============================================
-- PHP Streaming Proxy Database Schema
-- ============================================
-- Bu dosyayı phpMyAdmin'de Import edin
-- Veritabanınızı seçtikten sonra Import > Choose File > Go
-- ============================================

-- 1. Admin Kullanıcıları Tablosu
CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 2. Stream'ler Tablosu
CREATE TABLE IF NOT EXISTS streams (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    source_url TEXT NOT NULL,
    token VARCHAR(64) UNIQUE NOT NULL,
    stream_type ENUM('m3u8', 'direct') DEFAULT 'm3u8',
    is_active BOOLEAN DEFAULT TRUE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 3. Erişim Logları Tablosu
CREATE TABLE IF NOT EXISTS stream_logs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    stream_id INT,
    ip_address VARCHAR(45),
    user_agent TEXT,
    accessed_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (stream_id) REFERENCES streams(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- 4. Sistem Ayarları Tablosu
CREATE TABLE IF NOT EXISTS settings (
    setting_key VARCHAR(100) PRIMARY KEY,
    setting_value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- Varsayılan Veriler
-- ============================================

-- Varsayılan Admin Kullanıcısı
-- Kullanıcı Adı: admin
-- Şifre: 123456
INSERT INTO admins (username, password) VALUES 
('admin', '$2a$09$y6P9c4LyX9XEWWeJzGSbge8uuFSEEz9VHixQdJZchxCmbohlUEN.m')
ON DUPLICATE KEY UPDATE username=username;

-- Varsayılan Sistem Ayarları
INSERT INTO settings (setting_key, setting_value) VALUES 
('site_name', 'Streaming Proxy System'),
('max_concurrent_streams', '100'),
('enable_logging', '1')
ON DUPLICATE KEY UPDATE setting_value=VALUES(setting_value);

-- ============================================
-- Import Tamamlandı!
-- ============================================
-- Şimdi https://proxy.diz1.online/login.php adresine gidin
-- Kullanıcı: admin
-- Şifre: admin123
-- ============================================
