<?php
// Debug Tool - Stream Tester
// Bu dosyayı kullandıktan sonra SİLİN!
require_once 'config.php';

$token = $_GET['token'] ?? '';

if (empty($token)) {
    die('Usage: debug.php?token=YOUR_TOKEN');
}

echo "<h1>Stream Debug Tool</h1>";
echo "<style>body{font-family:monospace;padding:20px;background:#1a1a1a;color:#0f0;} h1,h2{color:#0ff;} .error{color:#f00;} .success{color:#0f0;} pre{background:#000;padding:10px;border:1px solid #333;overflow:auto;}</style>";

// Test 1: Database Connection
echo "<h2>1. Database Connection</h2>";
try {
    $db = getDBConnection();
    echo "<span class='success'>✓ Database connected</span><br>";
} catch (Exception $e) {
    echo "<span class='error'>✗ Database error: " . $e->getMessage() . "</span><br>";
    die();
}

// Test 2: Find Stream
echo "<h2>2. Stream Lookup</h2>";
$stmt = $db->prepare("SELECT * FROM streams WHERE token = ?");
$stmt->execute([$token]);
$stream = $stmt->fetch();

if (!$stream) {
    echo "<span class='error'>✗ Stream not found with token: $token</span><br>";
    echo "Available streams:<br>";
    $all = $db->query("SELECT id, name, token, is_active FROM streams")->fetchAll();
    foreach ($all as $s) {
        echo "- ID: {$s['id']}, Name: {$s['name']}, Token: {$s['token']}, Active: " . ($s['is_active'] ? 'Yes' : 'No') . "<br>";
    }
    die();
}

echo "<span class='success'>✓ Stream found</span><br>";
echo "ID: {$stream['id']}<br>";
echo "Name: {$stream['name']}<br>";
echo "Source: {$stream['source_url']}<br>";
echo "Active: " . ($stream['is_active'] ? 'Yes' : 'No') . "<br>";
echo "Token: {$stream['token']}<br>";

// Test 3: Fetch Source M3U8
echo "<h2>3. Fetch Source M3U8</h2>";
echo "Fetching: {$stream['source_url']}<br>";

$ch = curl_init($stream['source_url']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');

$content = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

if ($httpCode !== 200) {
    echo "<span class='error'>✗ Failed to fetch (HTTP $httpCode)</span><br>";
    if ($error) echo "cURL Error: $error<br>";
    die();
}

echo "<span class='success'>✓ Source fetched successfully (HTTP $httpCode)</span><br>";
echo "Content length: " . strlen($content) . " bytes<br>";
echo "<h3>First 500 characters:</h3>";
echo "<pre>" . htmlspecialchars(substr($content, 0, 500)) . "</pre>";

// Test 4: Parse M3U8
echo "<h2>4. Parse M3U8</h2>";
$lines = explode("\n", $content);
$urlCount = 0;
$m3u8Count = 0;

foreach ($lines as $line) {
    $line = trim($line);
    if (!empty($line) && $line[0] !== '#') {
        $urlCount++;
        if (stripos($line, '.m3u8') !== false) {
            $m3u8Count++;
        }
    }
}

echo "Total URLs found: $urlCount<br>";
echo "M3U8 playlists found: $m3u8Count<br>";
echo "Segments found: " . ($urlCount - $m3u8Count) . "<br>";

// Test 5: Generate Proxy URL
echo "<h2>5. Proxy URL</h2>";
$proxyUrl = SITE_URL . '/stream/' . $token . '.m3u8';
echo "<span class='success'>✓ Proxy URL generated</span><br>";
echo "URL: <a href='$proxyUrl' target='_blank' style='color:#0ff;'>$proxyUrl</a><br>";

// Test 6: Test Proxy
echo "<h2>6. Test Proxy Response</h2>";
echo "<a href='$proxyUrl' target='_blank' style='color:#0ff;padding:10px;background:#333;display:inline-block;margin:10px 0;text-decoration:none;'>Open Proxy URL</a><br>";

echo "<h2>✓ Debug Complete</h2>";
echo "<p style='color:#ff0;'>If everything shows ✓, your stream should work!</p>";
echo "<p style='color:#f00;'>DELETE THIS FILE (debug.php) AFTER TESTING!</p>";
