<?php
// Public landing page
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Streaming Proxy System</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
        }
        
        .container {
            text-align: center;
            padding: 40px;
        }
        
        .logo {
            font-size: 120px;
            margin-bottom: 30px;
            animation: float 3s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-20px); }
        }
        
        h1 {
            font-size: 48px;
            margin-bottom: 20px;
            text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
        }
        
        p {
            font-size: 20px;
            margin-bottom: 40px;
            opacity: 0.9;
        }
        
        .btn {
            display: inline-block;
            padding: 15px 40px;
            background: white;
            color: #667eea;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            font-size: 18px;
            transition: all 0.3s ease;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
        }
        
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
        }
        
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 30px;
            margin-top: 60px;
            max-width: 1000px;
        }
        
        .feature {
            background: rgba(255, 255, 255, 0.1);
            padding: 30px;
            border-radius: 20px;
            backdrop-filter: blur(10px);
            transition: transform 0.3s ease;
        }
        
        .feature:hover {
            transform: translateY(-10px);
        }
        
        .feature-icon {
            font-size: 48px;
            margin-bottom: 15px;
        }
        
        .feature h3 {
            font-size: 22px;
            margin-bottom: 10px;
        }
        
        .feature p {
            font-size: 16px;
            opacity: 0.8;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">🎬</div>
        <h1>Streaming Proxy System</h1>
        <p>Profesyonel M3U8 Stream Proxy Çözümü</p>
        <a href="login.php" class="btn">Admin Paneline Git</a>
        
        <div class="features">
            <div class="feature">
                <div class="feature-icon">🚀</div>
                <h3>Hızlı & Güvenilir</h3>
                <p>Yüksek performanslı stream proxy sistemi</p>
            </div>
            <div class="feature">
                <div class="feature-icon">🔒</div>
                <h3>Güvenli</h3>
                <p>Token tabanlı güvenlik sistemi</p>
            </div>
            <div class="feature">
                <div class="feature-icon">📊</div>
                <h3>İstatistikler</h3>
                <p>Detaylı izleme ve raporlama</p>
            </div>
            <div class="feature">
                <div class="feature-icon">⚡</div>
                <h3>Önbellekleme</h3>
                <p>Segment önbellekleme ile hızlı yükleme</p>
            </div>
        </div>
    </div>
</body>
</html>
