<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Demo Player - Streaming Proxy</title>
    <link href="https://vjs.zencdn.net/8.10.0/video-js.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #0f0f0f;
            color: white;
            min-height: 100vh;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            padding: 20px 40px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.3);
        }
        
        .header h1 {
            font-size: 24px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        
        .player-section {
            background: #1a1a1a;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.5);
            margin-bottom: 30px;
        }
        
        .video-js {
            width: 100%;
            height: 600px;
        }
        
        .controls-section {
            background: #1a1a1a;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.3);
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #aaa;
            font-weight: 500;
        }
        
        input[type="text"] {
            width: 100%;
            padding: 12px 15px;
            background: #2a2a2a;
            border: 2px solid #3a3a3a;
            border-radius: 10px;
            color: white;
            font-size: 16px;
            transition: all 0.3s ease;
        }
        
        input[type="text"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.2);
        }
        
        .btn {
            padding: 12px 30px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 10px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }
        
        .info-box {
            background: #2a2a2a;
            padding: 20px;
            border-radius: 10px;
            margin-top: 20px;
            border-left: 4px solid #667eea;
        }
        
        .info-box h3 {
            margin-bottom: 10px;
            color: #667eea;
        }
        
        .info-box p {
            color: #aaa;
            line-height: 1.6;
        }
        
        .info-box code {
            background: #1a1a1a;
            padding: 2px 8px;
            border-radius: 4px;
            color: #667eea;
            font-family: 'Courier New', monospace;
        }
        
        .example-urls {
            background: #2a2a2a;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
        }
        
        .example-urls h4 {
            color: #667eea;
            margin-bottom: 10px;
            font-size: 14px;
        }
        
        .example-urls ul {
            list-style: none;
        }
        
        .example-urls li {
            padding: 8px;
            background: #1a1a1a;
            margin-bottom: 5px;
            border-radius: 5px;
            font-size: 13px;
            color: #888;
            cursor: pointer;
            transition: all 0.2s ease;
        }
        
        .example-urls li:hover {
            background: #667eea;
            color: white;
        }
        
        .status {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            margin-top: 10px;
        }
        
        .status.loading {
            background: #f39c12;
            color: white;
        }
        
        .status.playing {
            background: #27ae60;
            color: white;
        }
        
        .status.error {
            background: #e74c3c;
            color: white;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🎬 Demo Video Player</h1>
    </div>
    
    <div class="container">
        <div class="player-section">
            <video id="player" class="video-js vjs-big-play-centered" controls preload="auto">
                <p class="vjs-no-js">
                    Video oynatmak için JavaScript'i etkinleştirin.
                </p>
            </video>
        </div>
        
        <div class="controls-section">
            <h2 style="margin-bottom: 20px;">Stream URL</h2>
            
            <div class="form-group">
                <label for="stream-url">Proxy Link veya M3U8 URL</label>
                <input type="text" id="stream-url" 
                       placeholder="http://yourdomain.com/proxy.php?token=YOUR_TOKEN">
            </div>
            
            <button class="btn" onclick="loadStream()">Yükle ve Oynat</button>
            <span id="status"></span>
            
            <div class="example-urls">
                <h4>📝 Örnek Kullanım:</h4>
                <ul>
                    <li onclick="fillExample(this.textContent)">
                        Admin panelinden oluşturduğunuz proxy linkini buraya yapıştırın
                    </li>
                </ul>
            </div>
            
            <div class="info-box">
                <h3>💡 Nasıl Kullanılır?</h3>
                <p>
                    1. <code>admin.php</code> sayfasından yeni bir stream ekleyin<br>
                    2. Oluşturulan proxy linkini kopyalayın<br>
                    3. Yukarıdaki alana yapıştırın ve "Yükle ve Oynat" butonuna tıklayın<br>
                    4. Stream otomatik olarak yüklenecek ve oynatılacaktır
                </p>
            </div>
            
            <div class="info-box" style="margin-top: 20px;">
                <h3>🔧 Teknik Detaylar</h3>
                <p>
                    Bu player <strong>Video.js</strong> kullanarak HLS stream'leri oynatır.<br>
                    Proxy sistemi sayesinde kaynak URL gizlenir ve güvenli bir şekilde stream edilir.<br>
                    Segment önbellekleme ile daha hızlı yükleme sağlanır.
                </p>
            </div>
        </div>
    </div>
    
    <script src="https://vjs.zencdn.net/8.10.0/video.min.js"></script>
    <script>
        let player;
        
        // Initialize player
        document.addEventListener('DOMContentLoaded', function() {
            player = videojs('player', {
                controls: true,
                autoplay: false,
                preload: 'auto',
                fluid: true,
                responsive: true,
                playbackRates: [0.5, 1, 1.5, 2],
                controlBar: {
                    children: [
                        'playToggle',
                        'volumePanel',
                        'currentTimeDisplay',
                        'timeDivider',
                        'durationDisplay',
                        'progressControl',
                        'playbackRateMenuButton',
                        'qualitySelector',
                        'fullscreenToggle'
                    ]
                }
            });
            
            // Event listeners
            player.on('loadstart', function() {
                updateStatus('loading', 'Yükleniyor...');
            });
            
            player.on('playing', function() {
                updateStatus('playing', 'Oynatılıyor');
            });
            
            player.on('error', function() {
                const error = player.error();
                updateStatus('error', 'Hata: ' + (error ? error.message : 'Bilinmeyen hata'));
            });
            
            player.on('pause', function() {
                updateStatus('', '');
            });
        });
        
        function loadStream() {
            const url = document.getElementById('stream-url').value.trim();
            
            if (!url) {
                alert('Lütfen bir stream URL\'si girin!');
                return;
            }
            
            updateStatus('loading', 'Yükleniyor...');
            
            player.src({
                src: url,
                type: 'application/x-mpegURL'
            });
            
            player.ready(function() {
                player.play().catch(function(error) {
                    console.error('Oynatma hatası:', error);
                    updateStatus('error', 'Oynatma başlatılamadı');
                });
            });
        }
        
        function updateStatus(className, text) {
            const statusEl = document.getElementById('status');
            statusEl.className = 'status ' + className;
            statusEl.textContent = text;
        }
        
        function fillExample(text) {
            // This is just a placeholder function
            alert('Admin panelinden bir stream ekleyin ve oluşturulan linki buraya yapıştırın.');
        }
        
        // Allow Enter key to load stream
        document.getElementById('stream-url').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                loadStream();
            }
        });
    </script>
</body>
</html>
