<?php
// Admin şifre sıfırlama ve test
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';

echo "<h1>Admin Şifre Sıfırlama</h1>";
echo "<style>body{font-family:monospace;padding:20px;} .success{color:green;} .error{color:red;}</style>";

// Test database connection
echo "<h2>1. Veritabanı Bağlantısı</h2>";
try {
    $db = getDBConnection();
    echo "<span class='success'>✓ Bağlantı başarılı</span><br>";
} catch (Exception $e) {
    echo "<span class='error'>✗ Hata: " . $e->getMessage() . "</span><br>";
    die();
}

// Check admins table
echo "<h2>2. Admins Tablosu</h2>";
try {
    $admins = $db->query("SELECT * FROM admins")->fetchAll();
    echo "<span class='success'>✓ Tablo bulundu</span><br>";
    echo "Toplam admin: " . count($admins) . "<br><br>";
    
    foreach ($admins as $admin) {
        echo "ID: {$admin['id']}<br>";
        echo "Kullanıcı: {$admin['username']}<br>";
        echo "Şifre Hash: " . substr($admin['password'], 0, 30) . "...<br>";
        echo "Oluşturma: {$admin['created_at']}<br><br>";
    }
} catch (Exception $e) {
    echo "<span class='error'>✗ Hata: " . $e->getMessage() . "</span><br>";
}

// Create new password hash
echo "<h2>3. Yeni Şifre Hash Oluştur</h2>";
$newPassword = '123456';
$newHash = password_hash($newPassword, PASSWORD_DEFAULT);
echo "Şifre: <strong>123456</strong><br>";
echo "Hash: <code>$newHash</code><br><br>";

// Update password
echo "<h2>4. Şifreyi Güncelle</h2>";
try {
    $stmt = $db->prepare("UPDATE admins SET password = ? WHERE username = 'admin'");
    $result = $stmt->execute([$newHash]);
    
    if ($result) {
        echo "<span class='success'>✓ Şifre güncellendi!</span><br>";
        echo "<strong>Kullanıcı: admin</strong><br>";
        echo "<strong>Şifre: 123456</strong><br><br>";
    } else {
        echo "<span class='error'>✗ Güncelleme başarısız</span><br>";
    }
} catch (Exception $e) {
    echo "<span class='error'>✗ Hata: " . $e->getMessage() . "</span><br>";
}

// Test login
echo "<h2>5. Giriş Testi</h2>";
try {
    $stmt = $db->prepare("SELECT * FROM admins WHERE username = ?");
    $stmt->execute(['admin']);
    $admin = $stmt->fetch();
    
    if ($admin) {
        echo "Kullanıcı bulundu: {$admin['username']}<br>";
        
        if (password_verify('123456', $admin['password'])) {
            echo "<span class='success'>✓ Şifre doğru! Giriş başarılı olmalı.</span><br>";
        } else {
            echo "<span class='error'>✗ Şifre yanlış!</span><br>";
        }
    } else {
        echo "<span class='error'>✗ Kullanıcı bulunamadı</span><br>";
    }
} catch (Exception $e) {
    echo "<span class='error'>✗ Hata: " . $e->getMessage() . "</span><br>";
}

echo "<hr>";
echo "<h2>✓ Tamamlandı</h2>";
echo "<p>Şimdi giriş yapmayı deneyin:</p>";
echo "<a href='login.php' style='padding:10px 20px;background:#667eea;color:white;text-decoration:none;border-radius:5px;'>Login Sayfasına Git</a>";
echo "<p style='margin-top:20px;'><strong>Kullanıcı:</strong> admin<br><strong>Şifre:</strong> 123456</p>";
echo "<p style='color:red;'><strong>ÖNEMLİ:</strong> Bu dosyayı kullandıktan sonra SİLİN!</p>";
