<?php
// Simple test script for stream.php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'config.php';

echo "<h1>Stream Test</h1>";

// Test token
$token = 'd53e037df4a8c6bc73d967ba2de3c338';

echo "<h2>1. Database Connection</h2>";
try {
    $db = getDBConnection();
    echo "✓ Connected<br>";
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
    die();
}

echo "<h2>2. Find Stream</h2>";
try {
    $stream = getStreamByToken($token);
    if ($stream) {
        echo "✓ Stream found<br>";
        echo "ID: {$stream['id']}<br>";
        echo "Name: {$stream['name']}<br>";
        echo "Source: {$stream['source_url']}<br>";
        echo "Type: " . ($stream['stream_type'] ?? 'N/A') . "<br>";
        echo "Active: " . ($stream['is_active'] ? 'Yes' : 'No') . "<br>";
    } else {
        echo "✗ Stream not found<br>";
        die();
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
    die();
}

echo "<h2>3. Fetch Source</h2>";
try {
    $result = fetchUrl($stream['source_url']);
    if ($result['success']) {
        echo "✓ Source fetched (HTTP {$result['http_code']})<br>";
        echo "Content length: " . strlen($result['content']) . " bytes<br>";
        echo "<h3>First 500 chars:</h3>";
        echo "<pre>" . htmlspecialchars(substr($result['content'], 0, 500)) . "</pre>";
    } else {
        echo "✗ Failed (HTTP {$result['http_code']})<br>";
        echo "Error: {$result['error']}<br>";
    }
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "<br>";
}

echo "<h2>4. Test Proxy URL</h2>";
$proxyUrl = SITE_URL . '/stream/' . $token . '.m3u8';
echo "Proxy URL: <a href='$proxyUrl' target='_blank'>$proxyUrl</a><br>";
